import { BaseError, WrappedError } from '../facade/errors';
import { DebugContext } from './debug_context';
/**
 * An error thrown if application changes model breaking the top-down data flow.
 *
 * This exception is only thrown in dev mode.
 *
 * <!-- TODO: Add a link once the dev mode option is configurable -->
 *
 * ### Example
 *
 * ```typescript
 * @Component({
 *   selector: 'parent',
 *   template: `
 *     <child [prop]="parentProp"></child>
 *   `,
 *   directives: [forwardRef(() => Child)]
 * })
 * class Parent {
 *   parentProp = "init";
 * }
 *
 * @Directive({selector: 'child', inputs: ['prop']})
 * class Child {
 *   constructor(public parent: Parent) {}
 *
 *   set prop(v) {
 *     // this updates the parent property, which is disallowed during change detection
 *     // this will result in ExpressionChangedAfterItHasBeenCheckedError
 *     this.parent.parentProp = "updated";
 *   }
 * }
 * ```
 * @stable
 */
export declare class ExpressionChangedAfterItHasBeenCheckedError extends BaseError {
    constructor(oldValue: any, currValue: any);
}
/**
 * Thrown when an exception was raised during view creation, change detection or destruction.
 *
 * This error wraps the original exception to attach additional contextual information that can
 * be useful for debugging.
 * @stable
 */
export declare class ViewWrappedError extends WrappedError {
    /**
     * DebugContext
     */
    context: DebugContext;
    constructor(originalError: any, context: DebugContext);
}
/**
 * Thrown when a destroyed view is used.
 *
 * This error indicates a bug in the framework.
 *
 * This is an internal Angular error.
 * @stable
 */
export declare class ViewDestroyedError extends BaseError {
    constructor(details: string);
}
