(function(app) {
  app.BooksComponent = ng.core
    .Component({
      selector: 'books',
      templateUrl: 'app/books.component.html',
      providers: [ng.http.HttpModule, app.BooksService]
    })                    
    .Class({
      constructor: [app.BooksService, function(service) {
        this.service = service;
        this.books = [];        
        this.error = '';
      }],
     getBooks: function() { 
       this.service.get()
           .subscribe(
             this.handleResponse.bind(this), this.handleError.bind(this));
     },                 
     handleResponse: function(books) {
       this.books = books;
     },
     handleError: function(error) {
       this.error = error;
     },
     ngOnInit: function() {
       this.getBooks();
     }
   });
})(window.app || (window.app = {}));