(function(app) {
  app.BooksComponent = ng.core
    .Component({
      selector: 'books',
      templateUrl: 'app/books.component.html',
      providers: [ng.http.HttpModule, app.BooksService]
    })                    
    .Class({
      constructor: [app.BooksService, function(service) {
        this.service = service;
        this.books = [];        
        this.message = '';
        this.newBook = {name: '', author: '', publisher: '', link: ''};
      }],
     getBooks: function() { 
       this.service.get()
           .subscribe(
             this.handleResponse.bind(this), this.handleError.bind(this));
     },                 
     handleResponse: function(books) {
       this.books = books;
     },
     handleError: function(error) {
       this.message = error;
     },
     saveBook: function() {
       this.service.post(this.newBook)
           .subscribe(
              this.updateMessage.bind(this), this.handleError.bind(this));
     },
     updateMessage: function(message) {
       this.message = message;
       this.getBooks();
     },
     deleteBook: function(id) {
       this.service.delete(id)
           .subscribe(
              this.updateMessage.bind(this), this.handleError.bind(this));
     },
     ngOnInit: function() {
       this.getBooks();
     }
   });
})(window.app || (window.app = {}));