(function(app) {
  app.BooksComponent = ng.core
    .Component({
      selector: 'book-list',
      templateUrl: 'books.html',
      providers: [ng.http.HTTP_PROVIDERS, app.BooksService],
      pipes: [app.BooksSortPipe]
    })                    
    .Class({
      constructor: [app.BooksService, function(_booksService) {
        this.service = _booksService;
        this.books = [];
        this.message = '';     
      }],
      getBooks: function() { 
        this.service.get()
                    .subscribe(
                      this.updateBooks.bind(this),
                      this.updateError.bind(this));
      },
      updateBooks: function(books) {
        this.books = books;
      },
      updateError: function(message) {
        this.message = message;
      },
      ngOnInit: function() {
        this.getBooks();
      }
    });
})(window.app || (window.app = {}));