(function(app) {
  app.BooksService = ng.core.Class({
    constructor: [ng.http.Http, function(_http) {
      this.http = _http;
    }],                                        
    extractData: function(response) {
      if(response.status !== 200)
        throw new Error("invalid response, status:" + response.status);
        
      return response.json();
    },
    returnException: function(error) {
      return Observable.throw(error.message || "Error: request failed");
    },
    get: function() {
      return this.http.get('/books')
                      .map(this.extractData)
                      .catch(this.returnException);
    }
    });
})(window.app || (window.app = {}));