(function(app) {
  app.BooksComponent = ng.core
    .Component({
      selector: 'book-list',
      templateUrl: 'books.html',
      providers: [ng.http.HTTP_PROVIDERS, app.BooksService],
      pipes: [app.BooksSortPipe]
    })                    
    .Class({
      constructor: [app.BooksService, function(_booksService) {
        this.service = _booksService;
        this.books = [];
        this.message = '';
        this.newBook = {
          name: '',
          author: '',
          publisher: '',
          link: ''
        }
      }],
      getBooks: function() { 
        this.service.get()
                    .subscribe(
                      this.updateBooks.bind(this),
                      this.updateError.bind(this));
      },
      updateBooks: function(books) {
        this.books = books;
      },
      updateError: function(message) {
        this.message = message;
      },                            
      addBook: function() {
        this.service.add(this.newBook)
                    .subscribe(
                      this.updateMessage.bind(this),
                      this.updateError.bind(this));
      },
      updateMessage: function(message) {
        this.message = message;
        this.getBooks();
      },
      disableAdd: function() {
        return this.newBook.name === '' ||
               this.newBook.author === '' ||
               this.newBook.publisher === '' ||
               this.newBook.link === '';
      },
      ngOnInit: function() {
        this.getBooks();
      }
    });
})(window.app || (window.app = {}));