(function(app) {
  app.BooksService = ng.core.Class({
    constructor: [ng.http.Http, function(_http) {
      this.http = _http;
    }],                                        
    extractData: function(response) {
      if(response.status !== 200)
        throw new Error("invalid response, status:" + response.status);
                       
      try {
        return response.json();        
      } catch(ex) {
        return response.text();
      }
    },
    returnException: function(error) {
      return Observable.throw(error.message || "Error: request failed");
    },
    get: function() {
      return this.http.get('/books')
                      .map(this.extractData)
                      .catch(this.returnException);
    },
    add: function(newBook) {
      var options = 
         {headers: new ng.http.Headers({'Content-Type': 'application/json'})};
      
      return this.http.post('/books', JSON.stringify(newBook), options)
                      .map(this.extractData)
                      .catch(this.returnException);      
    },
    delete: function(bookId) {
      return this.http.delete('/books/' + bookId)
                      .map(this.extractData)
                      .catch(this.returnException);      
    }
    });
})(window.app || (window.app = {}));