(defn prime [n]
  (not-any? zero? (map #(mod n %) (range 2 (inc (- n 1))))))

(defn primes
([] (primes 2))
([n]
  (let [next-value (+ n 1)]
  (lazy-seq
  (if (prime n) (cons n (primes next-value)) (primes next-value))))))

;(println (primes))
(println (take 10 (primes)))
(println (take 10 (drop 5 (primes))))

;(2 3 5 7 11 13 17 19 23 29)
;(13 17 19 23 29 31 37 41 43 47)