package com.agiledeveloper;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.GraphDatabaseService;

public class Neo4JSample {
  private final static String DB_PATH = "/tmp/neo4j_db";
  private GraphDatabaseService neo4jdb;

  private void createDB() {
    neo4jdb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);    
  }

  public void shutdownDB() {
    neo4jdb.shutdown();
  }

  public void run() {
    createDB();
    shutdownDB();        
  }
  
  public static void main(String[] args) {
    new Neo4JSample().run();
  }
}