package com.agiledeveloper;

import org.neo4j.graphdb.*;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class Neo4JSample {
  private final String DB_PATH = "/tmp/neo4j_db";
  private final String MAN = "man";
  private final String WOMAN = "woman";
  private final String NAME = "name";
  private GraphDatabaseService neo4jdb;

  public void run() {
    createDB();
    //connect();
    try (Transaction tx = neo4jdb.beginTx()) {
      createNode(MAN, "John");
      createNode(WOMAN, "Sara");
      listNodes(MAN, "John");
      listNodes(WOMAN, "Sara");
      //tx.success(); //to commit
    }
    shutdownDB();
  }

  public static void main(String[] args) {
    new Neo4JSample().run();
  }

  private void connect() {
    neo4jdb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(DB_PATH).newGraphDatabase();
  }

  private void listNodes(String label, String name) {
    ResourceIterable<Node> nodes = neo4jdb.findNodesByLabelAndProperty(DynamicLabel.label(label), NAME, name);
    for (Node node : nodes) {
      System.out.println(node.getProperty(NAME));
    }
  }

  private void createNode(String label, String name) {
    Node node = neo4jdb.createNode(DynamicLabel.label(label));
    node.setProperty(NAME, name);
  }

  private void createDB() {
    neo4jdb = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
  }

  private void shutdownDB() {
    neo4jdb.shutdown();
  }
}
