package com.agiledeveloper;

import java.io.IOException;

public class FileMonitor {
  private FileSystem _fileSystem;
  private Alarm _alarm;

  public FileMonitor(FileSystem fileSystem, Alarm alarm) {
    _fileSystem = fileSystem;
    _alarm = alarm;
  }

  // Original code with the failed attempt to test
//  public void observe(String path) {
//    _fileSystem.setPathToObserve(path);
//
//    new Thread(new Runnable() {
//      public void run() {
//        while(true) {
//          try {
//            if (_fileSystem.hasChanged()) {
//              _alarm.raise();
//            }
//            Thread.sleep(1000);
//          } catch (InterruptedException e) {
//            e.printStackTrace();
//          }
//        }
//      }
//    }).start();
//  }

  public void observe(String path) {
    setPathToObserve(path);

    new Thread(new Runnable() {
      public void run() {
        while (true) {
          try {
            checkFileSystemAndRaiseAlarm();
            Thread.sleep(1000);
          } catch (InterruptedException e) {
            e.printStackTrace();
          }
        }
      }
    }).start();
  }

  void checkFileSystemAndRaiseAlarm() {
    if (_fileSystem.hasChanged()) {
      _alarm.raise();
    }
  }

  void setPathToObserve(String path) {
    try {
      _fileSystem.setPathToObserve(path);
    } catch(IOException ex) {
      throw new FileSystemMonitorException();
    }
  }

}
