def closure = { x -> println "$x"}

closure(4)

date = new Date()
closure = { x -> println "$x $date"}
closure('hello on ')

closure = { x -> println "$x " + name() }

@groovy.transform.Immutable
class Human {
  String personName
  def name() { personName }
}

joe = new Human("Joe")
closure.delegate = joe
closure('hello from')

susan = new Human('Susan')
closure.delegate = susan
closure('hello from')

//Rather than changing the closure it is safe
//to change a copy of the closure.

//The hard way to do this is
def closureClone = closure.clone()
closureClone.delegate = susan
closureClone('hello from')

//or the easy way is
susan.with closure //how to send parameter?