@groovy.transform.Immutable class Days {
  int days
  def getAgo() {
    def today = Calendar.instance
    today.add(Calendar.DAY_OF_MONTH, -days)
    today.time
  }
}

@groovy.transform.Immutable class Years {
  int years
  def getAgo() {
    def today = Calendar.instance
    today.add(Calendar.YEAR, -years)
    today.time
  }

  def getFromNow() {
    def today = Calendar.instance
    today.add(Calendar.YEAR, years)
    today.time
  }
}

Integer.metaClass.getDays = {->
  new Days(delegate)
}

Integer.metaClass.getYears = {->
  new Years(delegate)
}

println 2.days.ago
//Wed Jun 20 07:36:55 MDT 2012

println 2.years.ago
//Tue Jun 22 07:36:55 MDT 2010

println 2.years.fromNow
//Sun Jun 22 07:36:55 MDT 2014
