class ProcessDSL {
  def playersAndScores = [:]
  
  def players(String[] names) {
    names.each { name ->
      playersAndScores[name] = 0
    }
  }
  
  def getWinner() {
    def winner = ''
    int winningScore = 0
    playersAndScores.each { player, score ->
      if(winningScore < score) {
        winningScore = score
        winner = player
      }
    }
    
    println "Winner is $winner with score $winningScore"
  }
  
  def methodMissing(String name, args) {
    playersAndScores[name] = args[0]
  }
  
  def propertyMissing(name) { name }
  
  def static process(dsl) {
    def code = """
      processor.with {
        $dsl
      }      
    """
    def binding = new Binding()
    binding.setProperty('processor', new ProcessDSL())
    (new GroovyShell(binding)).evaluate(code)    
  }
}

ProcessDSL.process(new File('scores.dsl').text)