class Expense {
  
  double total = 0
  def itemized = [:]
  
  def static process(dsl) {
    def binding = new Binding()
    def expense = new Expense()
    binding.setProperty("expense", expense)
    def code = """
      def block = { $dsl }
      expense.with block
    """
    def shell = new GroovyShell(binding)
    shell.evaluate(code)
    printf 'Total expense is $%.2f\n', expense.total
    println "Itemized expenses:"
    printf '%-20s %s\n', 'Item', 'Amount'
    expense.itemized.each { item, amount ->
      printf '%-20s %.2f\n', item, amount
    }
  }
  
  def methodMissing(String name, args) {
    if(args.size() == 1 && BigDecimal.isInstance(args[0])) {
      itemized[name] = itemized[name]?:0.0 + args[0]
      total += args[0]
    } else {
      println "$name ${args.join(', ')} is invalid"
    }
  }
}

Expense.process(new File('expenses.dsl').text)